from fileDownloadUtility import FileDownloader
from api_request import ApiRequest
import json
import urllib2 as urlreq
import logging

class URCapUpdateHandler :
    def __init__(self, device_client):
        global logger
        logger = logging.getLogger('daemon.' + __name__)
        self.device_client = device_client
        self.api_base_url=None
        self.api_request = ApiRequest()
        self.file_downloader = FileDownloader(device_client, "urcapUpdateDownload", "download-urcap_update_status.json")

    def connection_state_changed(self, check_for_update_url):
        self.check_for_update_url=check_for_update_url
        self.check_for_urcap_update(self.check_for_update_url)
        return True

    def check_for_urcap_update(self, url):
        try:
            req = urlreq.Request(url)
            response = urlreq.urlopen(req).read()
            update_info_json = json.loads(response)
            can_be_updated = update_info_json['canUpdate']
            if str(can_be_updated).lower() == "true" :
                new_version = update_info_json['latestUrCapVersion']
                update_info_json['message']
                logger.debug("URCap update available - " + new_version)
                self.api_request.notify_urcap_update_available(new_version)

        except Exception as err:
            logger.error("Error checking for URCap update: " + str(err))