import logging
# Handle everything that has to do with telemetry data
class TelemetryHandler:

    def __init__(self, device_client):
        self.device_client = device_client
        global logger
        logger = logging.getLogger('daemon.' + __name__)

    def send_message(self, message):
        try:
            self.device_client.send_message(message)
            return True
        except KeyboardInterrupt:
            logger.error("User initiated exit")
            return False
        except Exception as e:
            logger.error("Unexpected exception sending message! " + str(e))
            return False
