from os import makedirs
from os.path import exists, join
import logging

global logger
logger = logging.getLogger('daemon.' + __name__)
from FileGenerator import FileGenerator
from sherlock import dashboard_server

class SupportFileGenerator(FileGenerator):
    def generate(self, file_directory_path, correlation_id):
        directory_path = self._get_support_file_directory_path()
        filename = self._trigger_support_log_file(directory_path)
        support_file_path = join(directory_path, filename)
        new_file_name = join(file_directory_path, correlation_id + ".zip")
        self._copy_file(support_file_path, new_file_name)
        return new_file_name

    def _get_support_file_directory_path(self):
        if self._is_simulation():
            directory = "/ursim/programs/support_file/"
        else:
            directory = "/programs/support_file/"

        if not exists(directory):
            makedirs(directory)

        return directory

    def _trigger_support_log_file(self, path):
        dashboard = dashboard_server.DashboardControl("127.0.0.1")
        dashboard.connect()
        result = dashboard.generate_support_log_file(path)
        dashboard.disconnect()
        name = result.split(' ')[-1]
        return name