
import socket
import logging
import time

global logger
logger = logging.getLogger('daemon.' + __name__)

def assert_true(condition, message):
    if not condition == True:
        raise Exception(message)


class DashboardControl:
    def __init__(self, ip):
        self.ip = ip

        self.socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        self.socket.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
        self.socket.settimeout(60)

        # this is used to save the last received message
        self.msg = ''

    def connect(self, port=29999, tries=20):
        count = 0
        while count < tries:
            try:
                self.socket.connect((self.ip, port))
                self.socket.recv(1024)
                break
            except:
                assert_true(count < tries, "Unable to connect to dashboard server on " + self.ip + ":" + str(port))
                count += 1
                time.sleep(5)

    def disconnect(self):
        self.socket.shutdown(socket.SHUT_RDWR)
        self.socket.close()

    def __ur_send__(self, command):
        #logger.debug('send: ' + command)
        self.socket.send(bytes(command + '\n'))
        self.msg = self.socket.recv(1000).strip()
        return bytes.decode(self.msg, 'utf-8')

    def get_program_state(self):
        return self.__ur_send__('programState')

    def get_loaded_program(self):
        return self.__ur_send__('get loaded program')

    def generate_robot_configuration_file(self):
        #Support log file with system configuration only
        return self.__ur_send__('generate flight report system')

    def generate_support_log_file(self, path):
        #Support log file including flight records
        return self.__ur_send__('generate support file ' + path)
