#!/usr/bin/env python

import os
import logging
import logging.handlers
from SimpleXMLRPCServer import SimpleXMLRPCServer
from SocketServer import ThreadingMixIn
from urcapMediator import URCapMediator


if os.path.exists("/root/ur-serial"):
    directory = "/data/myUR/"
else:
    directory = "/tmp/"
if not os.path.exists(directory):
    os.makedirs(directory)

log_file=directory +'daemon_myur.log'
logger = logging.getLogger('daemon')

formatter = logging.Formatter('%(asctime)s %(name)-42s %(levelname)-8s %(message)s', "%Y-%m-%d %H:%M:%S")
handler = logging.handlers.RotatingFileHandler(log_file, maxBytes=20000000, backupCount=5)
logger.setLevel(logging.DEBUG)
handler.setFormatter(formatter)
logger.addHandler(handler)
logger.info("Starting daemon ..")


class MultithreadedSimpleXMLRPCServer(ThreadingMixIn, SimpleXMLRPCServer):
    pass


server = MultithreadedSimpleXMLRPCServer(("127.0.0.1", 40472))
server.RequestHandlerClass.protocol_version = "HTTP/1.1"
try :
    mediator = URCapMediator()
    server.register_instance(mediator)
    server.serve_forever()
except Exception as e:
    logger.error("Error in starting URCapMediator: " + str(e))

