#!/usr/bin/env python
import json
from azure.iot.device import IoTHubDeviceClient
import urllib2 as urlreq
import logging


class IotHubConnectionHandler:

    def __init__(self, conn_string=""):
        global logger
        logger = logging.getLogger('daemon.' + __name__)
        self.conn_string = conn_string
        self.method_response = None
        self.restart = False
        self.initialized = False
        self.device_client = None

    def init_device_client(self, product_info=""):
        logger.debug("init_device_client")
        if self.conn_string == "":
            raise Exception("Connection string is not defined. You need to get the device connection string before initializing device client")

        try:
            self.device_client = IoTHubDeviceClient.create_from_connection_string(str(self.conn_string),
                                                                                  websockets=True)
            self.device_client.patch_twin_reported_properties({"product_info": product_info})
            return True
        except Exception as exception:
            logger.exception(str(exception))
            raise exception

    def connect_device_client(self):
        logger.debug("connect_device_client")
        try:
            self.device_client.connect()
            return True
        except Exception as e:
            logger.error(e)
            raise e

    def disconnect_device_client(self):
        logger.debug("disconnect_device_client")
        try:
            self.device_client.disconnect()
            return True
        except Exception as e:
            logger.error(e)
            return False

    def get_connection_string(self, url):
        logger.debug("get_connection_string")
        try:
            req = urlreq.Request(url)
            response = urlreq.urlopen(req).read()
            self.conn_string = str(response)
            return self.conn_string
        except urlreq.HTTPError as err:
            message = json.loads(err.read())
            return message['detail']
