#!/usr/bin/env python

import subprocess
import os
import sys
import jobmanager
from datetime import datetime


skipInstall = not os.path.exists("/root/ur-serial")
dataFolder = str(sys.argv[1])
progressFile = str(sys.argv[2])
logfile = str(sys.argv[3])
hasBeenInstalled = str(sys.argv[4])
generation = str(sys.argv[5])
functionName = str(sys.argv[6])

INSTALLED_STATUS_FILE = dataFolder + hasBeenInstalled

def get_current_time():
    return datetime.now().strftime("%d/%m/%Y %H:%M:%S")

def log_to_file(logfile, message):
    logfile.write(get_current_time() + " : " + message + "\n")

def run_cmd(cmd, logfile, force=False):
    log_to_file(logfile, cmd)
    if not skipInstall or force:
        process = subprocess.Popen(cmd.split(), stdout=logfile, stderr=logfile)
        return process.wait()
    else:
        print(cmd + "\n")
        return 0


def is_prereqs_installed():
    manager = jobmanager.JobManager()
    log = manager.new_task("Check if VNC prerequisites are already installed ", logfile, skipInstall, dataFolder, progressFile)
    basic_prereq_exist = os.path.isfile(INSTALLED_STATUS_FILE) and x11vnc_is_installed()
    if (basic_prereq_exist is True) :
        rc_for_python3 = run_cmd("which python3", log, skipInstall)
        if (rc_for_python3 == 0):
            return True
    return False


def prepare_install_steps_g5(manager):
    manager.add_step("dpkg -i deps/vnc/nginx_1.15.12-1~jessie_i386.deb")

    if not x11vnc_is_installed() :
        manager.add_step("dpkg -i " + jobmanager.build_package_list("./deps/vnc/x11vnc_g5/"))

    manager.add_step("dpkg -i " + jobmanager.build_package_list("./deps/vnc/python3/"))
    manager.add_step("cp -r ./deps/vnc/VNC-UR/. " + dataFolder)
    manager.add_step("cp ./deps/vnc/VNC-UR/default.conf /etc/nginx/conf.d/")

def x11vnc_is_installed():
    manager = jobmanager.JobManager()
    log = manager.new_task("Check if x11vnc is already installed ", logfile, skipInstall, dataFolder, progressFile)
    return_code = run_cmd("which x11vnc", log, skipInstall)
    if (return_code != 0):
        return False
    return True

def install_vnc():
    manager = jobmanager.JobManager()
    log = manager.new_task("INSTALLING", logfile, skipInstall, dataFolder, progressFile)

    if not is_prereqs_installed():
        if(generation == "g5"):
            prepare_install_steps_g5(manager)
        manager.execute()
        jobmanager.run_command("touch " + INSTALLED_STATUS_FILE, log, False)

    manager.task_done()


def uninstall_vnc():
    manager = jobmanager.JobManager()
    log = manager.new_task("UNINSTALLING", logfile, skipInstall, dataFolder, progressFile)

    if is_prereqs_installed():
        manager.add_step("apt-get --yes --force-yes remove nginx")
        manager.add_step("apt-get --yes --force-yes remove x11vnc")
        manager.add_step("apt-get --yes --force-yes remove python3")
        manager.add_step("rm -rf " + dataFolder)
        manager.execute()
        jobmanager.run_command("rm " + INSTALLED_STATUS_FILE, log, False)

    manager.task_done()


def enable_vnc():
    manager = jobmanager.JobManager()
    log = manager.new_task("ENABLING VNC", logfile, skipInstall, dataFolder, progressFile)

    if is_prereqs_installed():
        disable_vnc()
        if(generation == "g5"):
            jobmanager.run_command("x11vnc -q -bg -display :0 -localhost -tag myur-x11vnc -timeout 60 ", log, skipInstall)

        jobmanager.run_command("nginx", log, skipInstall)
        jobmanager.run_command("/data/VNC-UR/utils/launch.sh --vnc localhost:5900 ", log,  skipInstall)
        jobmanager.run_command("nginx -s reload", log,  skipInstall)
        manager.task_done()
        exit(0)
    else :
        exit(1)


def disable_vnc():
    manager = jobmanager.JobManager()
    log = manager.new_task("DISABLING VNC", logfile, skipInstall, dataFolder, progressFile)
    jobmanager.run_command("x11vnc -R stop -display :0", log, skipInstall)
    jobmanager.run_command("pkill -f myur-x11vnc", log, skipInstall)
    jobmanager.run_command("pkill -f websockify", log, skipInstall)
    jobmanager.run_command("nginx -s quit", log, skipInstall)
    manager.task_done()

eval(functionName + "()")
