#!/usr/bin/env python

import os
import sys
import jobmanager


skipInstall = not os.path.exists("/root/ur-serial")
action = str(sys.argv[1])
dataFolder = str(sys.argv[2])
progressFile = str(sys.argv[3])
logfile = str(sys.argv[4])
hasBeenInstalled = str(sys.argv[5])
rebootRequired = str(sys.argv[6])
generation = str(sys.argv[7])
softwareVersion = str(sys.argv[8])

INSTALLED_STATUS_FILE = dataFolder + hasBeenInstalled
REBOOT_REQUIRED_FILE = rebootRequired


def setup_pip(log, skipInstall):
    cwd = os.getcwd()
    os.chdir("./deps/telemetry/pip-20.3.4")
    jobmanager.run_command("python setup.py install", log, skipInstall)
    os.chdir(cwd)

def install_watchdog(log, skipInstall):
    cwd = os.getcwd()
    jobmanager.run_command("Installing WatchDog Prerequisites", log, True)
    jobmanager.run_command("tar -xzf ./deps/telemetry/watchdog/watchdog-0.10.7.tar.gz -C /data/myUR/", log, skipInstall)
    jobmanager.run_command("tar -xzf ./deps/telemetry/watchdog/pathtools-0.1.2.tar.gz -C /data/myUR/", log, skipInstall)
    if not skipInstall :
        path_to_pathtools = "/data/myUR/pathtools-0.1.2"
        os.chdir(path_to_pathtools)
        jobmanager.run_command("python setup.py -q install", log, skipInstall)
        path_to_watchdog = "/data/myUR/watchdog-0.10.7"
        os.chdir(path_to_watchdog)
        jobmanager.run_command("python setup.py -q install", log, skipInstall)
        os.chdir(cwd)
    jobmanager.run_command("rm -rf /data/myUR/watchdog-0.10.7", log, skipInstall)
    jobmanager.run_command("rm -rf /data/myUR/pathtools-0.1.2", log, skipInstall)

def prepare_steps_g5(manager):
    manager.add_step("rm -f " + INSTALLED_STATUS_FILE)
    manager.add_step("dpkg -i deps/telemetry/python-pkg-resources_0.6.24-1_all.deb")
    manager.add_step("dpkg -i deps/telemetry/python-setuptools_0.6.24-1_all.deb")
    manager.add_step(setup_pip)
    manager.add_step("python -m pip install deps/telemetry/azure_iot_sdk/azure_iot_device-2.10.0-py2.py3-none-any.whl --no-index --find-links deps/telemetry/azure_iot_sdk/")
    manager.add_step("python -m pip install deps/telemetry/azure_storage_blob/azure_storage_blob-12.9.0-py2.py3-none-any.whl --no-index --find-links deps/telemetry/azure_storage_blob")
    manager.add_step(install_watchdog)

def install_telemetry():
    manager = jobmanager.JobManager()
    log = manager.new_task("INSTALLING", logfile, skipInstall, dataFolder, progressFile)
    if (generation == "g5"):
        prepare_steps_g5(manager)
    manager.execute()

    device_client_exit_code = jobmanager.run_command("pip -q --no-python-version-warning show azure-iot-device", log, False)
    blob_exit_code = jobmanager.run_command("pip -q --no-python-version-warning show azure-storage-blob", log, False)
    pathtools_exit_code = jobmanager.run_command("pip -q --no-python-version-warning show pathtools", log, False)
    watchdog_exit_code = jobmanager.run_command("pip -q --no-python-version-warning show watchdog", log, False)

    if (device_client_exit_code == 0 and blob_exit_code == 0 and pathtools_exit_code == 0 and watchdog_exit_code == 0):
        jobmanager.run_command("touch " + INSTALLED_STATUS_FILE, log, False)

    manager.task_done()


install_telemetry()
