#!/usr/bin/env python

import os
import sys
import jobmanager

action = str(sys.argv[1])
skipInstall = not os.path.exists("/root/ur-serial")
dataFolder = str(sys.argv[2])
progressFile = str(sys.argv[3])
logfile = str(sys.argv[4])

def install_usb_ethernet_driver():
    manager = jobmanager.JobManager()
    if action == "INSTALL":
        manager.new_task("INSTALLING USB ETH Drivers", logfile, skipInstall, dataFolder, progressFile)
        manager.add_step("dpkg --force-overwrite -i " + jobmanager.build_package_list("./deps/telemetry/usb_eth_driver_g5/"))
    else :
        manager.new_task("UN-INSTALLING USB ETH Drivers", logfile, skipInstall, dataFolder, progressFile)
        manager.add_step("dpkg -P ur-remote-access-net-setup")
        manager.add_step("dpkg -P ifplugd")
        manager.add_step("dpkg -P libdaemon0")
        manager.add_step("dpkg -P ur-usb-ethernet-modules")
    manager.execute()
    manager.task_done()

install_usb_ethernet_driver()