import logging
import threading
import time

import requests

global logger
logger = logging.getLogger("daemon." + __name__)


class AutoConnectService:
    def __init__(self, iotHubConnectionHandler):
        self.auto_connect_thread = None
        self.base_url = "http://localhost:36011/api/"
        self.endpoint_url = self.base_url + "auto-connect"

        self.iotHubConnectionHandler = iotHubConnectionHandler
        self._start_service()

    def _start_service(self):
        # Start the periodic task in a separate thread
        self.auto_connect_thread = threading.Thread(target=self._periodic_check)
        self.auto_connect_thread.daemon = True
        self.auto_connect_thread.start()

    def _periodic_check(self):
        while True:
            # sleep for 1 hour - sleep first to avoid interfering with initialization of device client
            time.sleep(3600)
            try:
                if self.iotHubConnectionHandler.device_client is None:
                    continue

                if self.iotHubConnectionHandler.device_client.connected is False:
                    # Call the /auto-connect endpoint
                    logger.info(
                        "Client is currently not connected, attempting to autoconnect..."
                    )
                    self._call_autoconnect_endpoint()
            except Exception:
                logger.exception("Error calling %s" % self.endpoint_url)

    def _call_autoconnect_endpoint(self):
        r = requests.post(self.endpoint_url, timeout=20)
        logger.debug("Request result for /api/auto-connect is :: " + r.text)
        if r.status_code != 200:
            logger.error("Error in request to " + self.endpoint_url)
