import requests
import json
import logging

logger = logging.getLogger('daemon.' + __name__)
class ApiRequest:
    def __init__(self):
        self.base_url = "http://localhost:36011/api/"

    def get_program_variables(self):
        r = requests.get(self.base_url + 'get-program-variables')
        return r.text

    def request_remote_access(self, requesters_name):
        data = json.dumps({
            "requesters_name": requesters_name
        })
        return self._post_request('request-remote-access', data)

    def request_start_remote_access_session(self, requesters_name, domain):
        data = json.dumps({
            "requesters_name": requesters_name,
            "domain": domain
        })
        return self._post_request('request-start-remote-access-session', data)

    def end_remote_session(self):
        return self._post_request('end-remote-session', None)

    def notify_urcap_update_available(self, urcap_version_new):
        data = json.dumps({
            "latestUrCapVersion": urcap_version_new
        })
        return self._post_request('notify-urcap-update-available', data)

    def request_to_start_software_update(self, target_version):
        data = json.dumps({
            "target_version": target_version
        })
        return self._post_request('notify-software-update-requested', data)

    def _post_request(self, endpoint, data):
        url = str(self.base_url) + str(endpoint)
        r = requests.post(url, data=data)
        d = json.loads(r.text)
        logger.debug("Request result for " + url + " is :: " + r.text)
        if r.status_code != 200:
            logger.error("Error in request to " + url + " with data " + str(data))
            raise Exception(d["message"])
        return d["message"]